// initialize functions
$().ready(function () {

    // XHTML compliant _blank target scripts
    // use rel='popup' to open a small popup window
    $('a[rel*=popup]').click(function () {
        window.open(this.href, 'popup', 'resizable=yes,scrollbars=yes,toolbar=no,location=no,menubar=no,width=500,height=500');
        return false;
    });

    // use rel='external' to open an external url in a new window
    $('a[rel*=external]').click(function () {
        window.open(this.href, 'popup', 'resizable=yes,scrollbars=yes,toolbar=yes,location=yes,menubar=yes');
        return false;
    });

});

$(function () {
    var enterKeyCode = 13;
    var inputTypes = ['checkbox', 'radio', 'text', 'password', '']
    $(document).on('keydown keyup', 'input', function (e) {
        if(e.which !== enterKeyCode || e.target.tagName.toLowerCase() !== 'input') {
            return true;
        }
        var type = e.target.type || '';
        if(inputTypes.indexOf(type) === -1)
            return true;        
        
        var $target = $(e.target);
        var $closestsParentForm = $target.closest('form');
        if($closestsParentForm.length && $closestsParentForm.get(0).id === 'signedForm') {
            if (!$target.hasClass('input-submit-allowed')) {
                e.preventDefault();
                return false;
            }
        }
        return true;
    })
});

var NL3 = (function(){

    function setCookie(name, value, options) {
        options = $.extend({
            path: '/'
        }, options);

        if (options.expires instanceof Date) {
            options.expires = options.expires.toUTCString();
        }

        let updatedCookie = encodeURIComponent(name) + "=" + encodeURIComponent(value);

        for (var optionKey in options) {
            updatedCookie += "; " + optionKey;
            var optionValue = options[optionKey];
            if (optionValue !== true) {
                updatedCookie += "=" + optionValue;
            }
        }

        document.cookie = updatedCookie;
    }

    function setLanguageCookie(culture) {
        setCookie('language', culture, {secure:true})
    }
    
    return {
        setLanguageCookie: setLanguageCookie,
        setCookie: setCookie
    }
})();
