$().ready(function () {
    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    function _defineProperties(target, props) {
        for (var i = 0; i < props.length; i++) {
            var descriptor = props[i];
            descriptor.enumerable = descriptor.enumerable || false;
            descriptor.configurable = true;
            if ("value" in descriptor) descriptor.writable = true;
            Object.defineProperty(target, descriptor.key, descriptor);
        }
    }

    function _createClass(Constructor, protoProps, staticProps) {
        if (protoProps) _defineProperties(Constructor.prototype, protoProps);
        if (staticProps) _defineProperties(Constructor, staticProps);
        return Constructor;
    }

    var Tooltip = function () {
        function Tooltip(element) {
            _classCallCheck(this, Tooltip);

            this.element = element;            

            if (this.element.getAttribute('data-tooltip') === null) {
                throw new Error("Tooltip text is missing. Add attribute data-tooltip and the content of the tooltip as value.");
            }

            this.setEvents();
        }

        _createClass(Tooltip, [{
            key: "setEvents",
            value: function setEvents() {
                var that = this;
                var trigger = this.element.getAttribute('data-tooltip-trigger');

                if (!trigger || trigger.indexOf('hover') !== -1) {
                    this.element.addEventListener('mouseover', this.element.fn_mouseover = function (e) {
                        var element = e.target;
                        clearTimeout(element.hoverleavetimeoutid);
                        if (element.getAttribute('aria-describedby') !== null) return;
                        e.preventDefault();
                        var pos = element.getAttribute('data-tooltip-position') || 'top';
                        var tooltip = that.createTooltip(element, pos);
                        document.body.appendChild(tooltip);
                        that.positionAt(element, tooltip, pos);
                    });
                    this.element.addEventListener('focus', function (e) {
                        var element = e.target;
                        if (element.getAttribute('aria-describedby') !== null) return;
                        var hasFocus = document.activeElement === e.target;
                        if(hasFocus === false) return;
                        e.preventDefault();
                        var pos = element.getAttribute('data-tooltip-position') || 'top';
                        var tooltip = that.createTooltip(element, pos);
                        document.body.appendChild(tooltip);
                        that.positionAt(element, tooltip, pos);
                    });
                    this.element.addEventListener('blur', function (e) {
                        if (e.target.classList.contains('js-tooltip-pinned')) {
                            return;
                        }

                        Tooltip.close(e.target);
                    });
                    this.element.addEventListener('mouseout', this.element.fn_mouseout = function (e) {
                        if (e.target.classList.contains('js-tooltip-pinned')) {
                            return;
                        }

                        e.target.hoverleavetimeoutid = setTimeout(function(){
                            Tooltip.close(e.target);
                        }, 400);
                    });
                }

                if (trigger && trigger.indexOf('click') !== -1) {
                    this.element.addEventListener('click', function (e) {
                        var element = e.target;
                        e.preventDefault();
                        element.focus();
                        if (element.getAttribute('aria-describedby') === null) {
                            var pos = element.getAttribute('data-tooltip-position') || 'top';
                            var tooltip = that.createTooltip(element, pos);
                            document.body.appendChild(tooltip);
                            that.positionAt(element, tooltip, pos);
                        } else if (!element.classList.contains('js-tooltip-pinned')) { // Pin tooltip.
                            // Close other pinned tooltips.
                            $('.js-tooltip-pinned').each(function (i, pinnedElement) {
                                pinnedElement.classList.remove('js-tooltip-pinned');
                                Tooltip.close(pinnedElement);
                            });

                            // Pin tooltip.
                            element.classList.add('js-tooltip-pinned');

                            // Remove labelledby, otherwise screen readers will read the text of the tooltip twice.
                            element.removeAttribute('aria-labelledby');
                        } else {
                            Tooltip.close(element);
                            element.classList.remove('js-tooltip-pinned');
                        }
                    });
                }

                document.getElementsByTagName('body')[0].addEventListener('click', function (event) {
                    if (!event.target.classList.contains('js-tooltip') && !event.target.classList.contains('tooltip') && !event.target.classList.contains('tooltip-content')) {
                        Tooltip.closeAll();
                    }
                });
            }
        }, {
            key: "createTooltip",
            value: function createTooltip(element, pos) {
                var id = 'tooltip-' + Math.random().toString(36).substr(2, 9);
                var tooltip = document.createElement('div');
                tooltip.className = 'tooltip-popper';
                tooltip.setAttribute('id', id);
                tooltip.setAttribute('role', 'tooltip');
                tooltip.setAttribute('x-placement', pos);
                element.setAttribute('aria-describedby', id);
                element.setAttribute('aria-labelledby', id);
                var tooltipInner = document.createElement('div');
                tooltipInner.className = 'tooltip';
                var tooltipContent = document.createElement('div');
                tooltipContent.className = 'tooltip-content';
                tooltipContent.innerHTML = element.getAttribute('data-tooltip');
                tooltipInner.appendChild(tooltipContent);
                tooltip.appendChild(tooltipInner);
                tooltip.addEventListener('mouseover', function(){
                    element.fn_mouseover({target: element})
                });
                tooltip.addEventListener('mouseout', function(){
                    element.fn_mouseout({target: element})
                });
                return tooltip;
            }
            /**
             * Positions the tooltip.
             *
             * @param {object} parent - The trigger of the tooltip.
             * @param {object} tooltip - The tooltip itself.
             * @param {string} posHorizontal - Desired horizontal position of the tooltip relatively to the trigger (left/center/right)
             * @param {string} posVertical - Desired vertical position of the tooltip relatively to the trigger (top/center/bottom)
             *
             */

        }, {
            key: "positionAt",
            value: function positionAt(parent, tooltip, pos) {
                var parentCoords = parent.getBoundingClientRect(),
                    left,
                    top;
                var tooltipWidth = tooltip.offsetWidth;
                var dist = 8;
                left = parseInt(parentCoords.left) + (parent.offsetWidth - tooltip.offsetWidth) / 2;

                switch (pos) {
                    case 'bottom':
                        top = parseInt(parentCoords.bottom) + dist;
                        break;

                    default:
                    case 'top':
                        top = parseInt(parentCoords.top) - tooltip.offsetHeight - dist;
                }

                if (left < 0) {
                    left = parseInt(parentCoords.left);
                }

                if (top + tooltip.offsetHeight >= window.innerHeight) {
                    top = parseInt(parentCoords.top) - tooltip.offsetHeight - dist;
                }

                top = top < 0 ? parseInt(parentCoords.bottom) + dist : top;

                if (window.innerWidth < left + tooltipWidth) {
                    tooltip.style.right = dist + 'px';
                } else {
                    tooltip.style.left = left + 'px';
                }

                tooltip.style.top = top + pageYOffset + 'px';
            }
        }], [
            {
                key: "closeAll",
                value: function closeAll() {
                    var that = this;
                    var elements = document.querySelectorAll('.js-tooltip[aria-describedby]');
                    for (var i = 0; i < elements.length; i++) {
                        elements[i].classList.remove('js-tooltip-pinned');
                        that.close(elements[i]);
                    }
                }
            }, {
                key: "close",
                value: function close(element) {
                    var popperId = element.getAttribute('aria-describedby');

                    element.removeAttribute('aria-describedby');
                    element.removeAttribute('aria-labelledby');

                    if (popperId !== null) {
                        var popperElement = document.getElementById(popperId);
                        if (popperElement !== null) {
                            document.body.removeChild(popperElement);
                        }
                    }
                }
            }
        ]);
        
        return Tooltip;
    }();

    $('.js-tooltip').each(function (i, element) {
        new Tooltip(element);
    })

    document.body.addEventListener('keydown', function (e) {
        if (e.code === 'Escape') {
            Tooltip.closeAll();
        }
    });
});